<?php declare(strict_types=1);

namespace TheissenDownloadTab;

use Shopware\Core\Framework\Plugin;
use Shopware\Core\Framework\Plugin\Context\InstallContext;
use Shopware\Core\Framework\Plugin\Context\UninstallContext;

class TheissenDownloadTab extends Plugin
{
    public function install(InstallContext $installContext): void
    {
        parent::install($installContext);

        $config = $this->container->get('Shopware\Core\System\SystemConfig\SystemConfigService');
        $filetypes = ["jpg","png","gif","svg","tiff","eps","raw","webp","mp4"];
        $config->set('TheissenDownloadTab.config.filetypes', $filetypes);
    }

    public function uninstall(UninstallContext $uninstallContext): void
    {
        parent::uninstall($uninstallContext);
        $config = $this->container->get('Shopware\Core\System\SystemConfig\SystemConfigService');
        $filetypes = [];
        $config->set('TheissenDownloadTab.config.filetypes', $filetypes);
    }
}
