<?php
namespace TheissenDownloadTab\Subscriber;

use Shopware\Core\Content\Product\Aggregate\ProductMedia\ProductMediaCollection;
use Shopware\Core\Content\Product\ProductEvents;
use Shopware\Core\Framework\Context;
use Shopware\Core\Framework\DataAbstractionLayer\Event\EntityLoadedEvent;
use Shopware\Core\System\SystemConfig\SystemConfigService;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;

class ProductSubscriber implements EventSubscriberInterface
{
    private SystemConfigService $configService;

    public function __construct(SystemConfigService $configService){
        $this->configService = $configService;
        $config = $this->configService->get('TheissenDownloadTab');
        $this->config = (object) $config['config'];
    }

    public static function getSubscribedEvents(): array
    {
        return [
            ProductEvents::PRODUCT_LOADED_EVENT => ['loaded'],
        ];
    }

    /**
     * @param EntityLoadedEvent $event
     */
    public function loaded(EntityLoadedEvent $event): void
    {

        $context = $event->getContext();

        if($context->getScope() === Context::CRUD_API_SCOPE){
            return;
        }

        foreach ($event->getEntities() as $product) {

            if($this->config->implementation === 'backend') {
                $media = $product->getMedia();
                if (!$media) {
                    continue;
                }

                $filteredMedia = new ProductMediaCollection;
                $downloadableMedia = new ProductMediaCollection;
                foreach ($media as $item) {
                    $media = $item->getMedia();
                    $mime = strtolower($media->getFileExtension());
                    if (isset($this->config->filetypes)) {
                        if (in_array($mime, $this->config->filetypes, true)) {
                            $filteredMedia->add($item);
                        } else {
                            $downloadableMedia->add($item);
                        }
                    }
                }
                $product->setMedia($filteredMedia);
                $product->downloadableMedia = $downloadableMedia;

            } else {
                $product->downloadableMedia = null;
            }

            $product->TheissenDownloadTabConfig = $this->config;
        }
    }
}
