<?php
namespace TheissenDownloadTab\Utils;

use Shopware\Core\Content\Product\Aggregate\ProductMedia\ProductMediaCollection;
use Shopware\Core\System\SystemConfig\SystemConfigService;
use Twig\Extension\AbstractExtension;
use Twig\TwigFunction;

class TheissenDownloadTabTwigExtension extends AbstractExtension
{
    public function __construct(SystemConfigService $configService){
        $this->configService = $configService;
        $config = $this->configService->get('TheissenDownloadTab');
        $this->config = (object) $config['config'];
    }

    public function getFunctions(){
        return [
            new TwigFunction('filterMedia', [$this, 'filterMedia'], [ 'needs_context' => true ]),
        ];
    }

    public function filterMedia(&$context)
    {
        $page = $context['page'];
        $product = $page->getProduct();
        $media = $product->getMedia();

        $filteredMedia = new ProductMediaCollection;
        $downloadableMedia = new ProductMediaCollection;
        foreach ($media as $item) {
            $mime = strtolower($item->getMedia()->getFileExtension());
            if (isset($this->config->filetypes)) {
                if (in_array($mime, $this->config->filetypes, true)) {
                    $filteredMedia->add($item);
                } else {
                    $downloadableMedia->add($item);
                }
            }
        }
        $product->setMedia($filteredMedia);
        $product->downloadableMedia = $downloadableMedia;
        $context['page']->setProduct($product);

    }
}
